

public class SourcePosition {

  public int start, finish;

  public static final int INIT = -1;
  public static final int DUMMY = -2;
  
  public SourcePosition () {
    start = INIT;
    finish = INIT;
  }

  public SourcePosition (int s, int f) {
    start = s;
    finish = f;
  }
  
  public void setPosition( Token t){
      if ( start == INIT && finish == INIT){
          start = t.beginLine;
          finish = t.endLine;
      }
      else
      {
          finish = t.endLine;
      }
  }

  public void setPosition( SourcePosition pos){
      if ( start == INIT && finish == INIT){
          start = pos.start;
          finish = pos.finish;
      }
      else
      {
          finish = pos.finish;
      }
  }

  public String toString() {
    return "(" + start + ", " + finish + ")";
  }
}
