/***************************************************************************
 *   Copyright (C) 2005 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GROUP_H
#define GROUP_H

#include <qobject.h>
#include <qstringlist.h>
#include <kdebug.h>
#include "mylistitem.h"

/**
   @author Doo-Hyun Jang <ring0320@nate.com>
*/
class Group : public MyListItem
{
Q_OBJECT
public:
	Group(QString id, QString name);

	~Group();
	// const QString& getGID() const { return m_sGID; }
	// const QString& getGName() const { return m_sGName; }
	const QStringList& getBuddyList() const { return m_slBuddyList; }

	void addBuddyHandle( const QString& sHandle );
	void removeBuddyHandle( const QString& sHandle );
	// void setGName( QString sName ) { m_sName = sName; }

private:
	// QString     m_sID;          // 그룹ID
	// QString     m_sName;        // 그룹명
	/*! Handle (CMN) 값 QStringList */
	QStringList m_slBuddyList;
};
#endif
