/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "grouplist.h"

GroupList::GroupList()
	: QObject()
{
	m_GroupList.clear();
}


GroupList::~GroupList()
{
}

Group * GroupList::addGroup(QString sGroupID, QString sGroupName)
{
    Group *pGroup;

    if ( IsGroupExist( sGroupID ) ) return 0;

    pGroup = new Group( sGroupID, sGroupName );

    m_GroupList.append(pGroup);

    // emit groupAdded(pGroup);

    return pGroup;
}

Group * GroupList::getGroupByID(QString sGroupID) const
{
    QPtrListIterator<Group> iterator(m_GroupList);
    Group * pGroup;

    while(iterator.current() != 0)
    {
        pGroup = iterator.current();
        if ( pGroup->getGID() == sGroupID )
        {
            return pGroup;
        }
        ++iterator;
    }
    return 0;
}

Group * GroupList::getGroupBySortPosition(int nSortPosition) const
{
    /// 구현해야함.
}

void GroupList::removeGroup(QString sGroupID)
{
	// Group* pGroup;
    /// 구현해야함.

    // emit groupRemoved(pGroup);
}

void GroupList::renameGroup(QString sGroupID, QString sNewName)
{
    /// 구현해야함.
}

void GroupList::deleteGeneralGroups()
{
    /// 구현해야함.
}

bool GroupList::IsGroupExist(QString sGroupID)
{
    return getGroupByID( sGroupID ) != 0;
}


Group * GroupList::getGroupByName(QString sName) const
{
    QPtrListIterator<Group> iterator(m_GroupList);
    Group * pGroup;

    while(iterator.current() != 0)
    {
        pGroup = iterator.current();
        if ( pGroup->getGName() == sName )
        {
            return pGroup;
        }
        ++iterator;
    }
    return 0;
}

Group * GroupList::addGroup(Group * pGroup)
{
	if ( IsGroupExist( pGroup->getGID() ) ) return 0;
	m_GroupList.append(pGroup);
  
	return pGroup;
}

const QStringList &GroupList::getGIDListByBuddyHandle(QString sHandle)
{
	QStringList slGID;
	slGID.clear();
	
	QPtrListIterator<Group> iterator(m_GroupList);
	while(iterator.current() != 0)
	{
		Group * pGroup = iterator.current();
		if ( pGroup->getBuddyList().find( sHandle ) != pGroup->getBuddyList().end() )
		{
			slGID.append( pGroup->getGID() );
#ifdef NETDEBUG
			kdDebug() << "GROUP : " << pGroup->getGName() << endl;
#endif
		}
		++iterator;
	}
	return slGID;
}

#include "grouplist.moc"

