/***************************************************************************
 *   Copyright (C) 2007 by Doo-Hyun Jang                                   *
 *   ring0320@nate.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MEMOPOPUPVIEW_H
#define MEMOPOPUPVIEW_H

#include <qlabel.h>
#include <qpushbutton.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kapplication.h>
#include <kconfig.h>

#include "../util/emoticon.h"
#include "../util/common.h"
#include "memopopupinterface.h"

class QLabel;
class QPushButton;
class Emoticon;

/**
   @author Doo-Hyun Jang <ring0320@nate.com>
*/
class MemoPopupView : public MemoPopup
{
Q_OBJECT
public:
    enum SendType { Reply, ReplyAll, Forward };
  
    MemoPopupView(QWidget* parent = 0, const char *name = 0);
    ~MemoPopupView();

    void setSender(const QString &sSender);
    void setReceiver(const QString &sReceiver);
    void setBody(const QString &sBody);
	void setTitle( const QString &sTitle ) { m_sTitle = sTitle; Common::fixOutString( m_sTitle ); kdDebug() << "XXXXXXXXXXXXx [" << m_sTitle << "]" << endl; }
	void setDate( QString sDate ) { m_sDate = sDate; }
	void setUUID( QString UUID ) { sUUID = UUID; }

private:
    Emoticon*         pEmoticon;
	/*!
	 * 이모티콘 적용안한 원문
	 * Reply에 쓰임.
	 */
	QString sOrigText;
	QString sUUID;
	QString m_sTitle;
	QString m_sDate;
	KConfig*          config;
	
protected:
	virtual void closeEvent ( QCloseEvent * e );

private slots:
    void slotReply();
    void slotReplyAll();
    void slotForward();
	void slotDelete();

signals:
	void replyMemo( MemoPopupView::SendType, const QString& , const QString& );
	void deleteMemo( const QString & );
	void closeMemoPopup( MemoPopupView * );
};

#endif
