/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "memopopupinterface.h"

#include <kcomponentdata.h>
#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QVBoxLayout>

static const char* const image1_data[] = {
    "28 28 122 2",
    ".D c #1a5a98",
    "#Z c #27649d",
    ".K c #28639d",
    ".Q c #2867a2",
    ".G c #2c6ca6",
    ".I c #316da6",
    ".E c #35659a",
    ".6 c #356fa5",
    ".R c #3572ab",
    ".l c #366ba1",
    "#g c #3772a9",
    ".S c #3974ab",
    ".x c #3b689a",
    "#1 c #3b71a5",
    ".L c #3c74a8",
    "#T c #3c78af",
    "#R c #3f75aa",
    ".J c #4178ad",
    "#V c #4377ab",
    ".B c #4483b9",
    "#2 c #4579ab",
    ".d c #4685b8",
    ".y c #4775a6",
    ".1 c #477bae",
    ".P c #4789bd",
    ".0 c #4b7eb0",
    ".f c #4b8fc1",
    ".k c #4c7cac",
    "#f c #4c83b3",
    ".e c #4c8ebf",
    "#p c #4d85b5",
    ".v c #4d8abc",
    ".Z c #4e80b1",
    ".c c #4e85b6",
    ".5 c #508abd",
    ".m c #5183b2",
    ".Y c #5282b1",
    ".X c #5383b2",
    ".M c #538bba",
    ".w c #5784b1",
    ".n c #5b91be",
    ".W c #628eb8",
    "#W c #638eb5",
    ".b c #6491bc",
    ".o c #66a0cb",
    ".O c #6aaed9",
    ".2 c #6b98c3",
    "#Y c #6b9ac7",
    ".u c #6eb1dc",
    "#C c #6fa1c6",
    ".g c #6fa1c9",
    ".p c #71b1d9",
    ".F c #76b8e3",
    ".h c #779fc4",
    ".3 c #7ca8d1",
    ".A c #7cbee8",
    ".q c #7ec2e7",
    ".a c #7fa2c5",
    ".z c #81c4eb",
    ".N c #81c9ee",
    "#o c #84adc9",
    ".t c #84caef",
    "#I c #85aecb",
    "#U c #85b0cf",
    ".s c #88d1f4",
    ".r c #89d4f5",
    "#J c #8cb9d5",
    ".V c #8dadcc",
    "#B c #92bfe1",
    "#e c #93bfe2",
    ".4 c #95c2e6",
    "#n c #96b8d3",
    "#3 c #9ab7d2",
    "#K c #9ac2da",
    "#0 c #9bb8d3",
    "#h c #9fbcd1",
    "#A c #a1c4e1",
    "#D c #a2c6dd",
    "#N c #a6bfd2",
    "#S c #a6c4e0",
    "#z c #a7c4db",
    "#X c #a7c6e4",
    ".i c #a9c1d8",
    "#y c #a9c2d5",
    "#P c #a9cbe0",
    "#d c #a9cceb",
    "#m c #afcae2",
    "#x c #b1c6d5",
    ".# c #b7cbdf",
    "#O c #b7d3e5",
    ".7 c #b8d1e6",
    "#w c #b9cbd7",
    "#c c #bbd6ef",
    "#M c #beced9",
    "#q c #bed1e3",
    "#v c #c1d1da",
    "#i c #c1d1db",
    "#H c #c2d7ea",
    ".T c #c2daf0",
    "#u c #c5d4da",
    "#F c #c6d5de",
    ".H c #c6d6e5",
    "#l c #c6daed",
    ".U c #c7d7e9",
    "#b c #ccdff2",
    "#t c #cfdbe0",
    ".j c #d4e0ec",
    "#E c #d4e5ef",
    "#L c #dbe9f2",
    "#a c #dce9f6",
    "#s c #dde6ea",
    "#j c #e2e9ed",
    ".C c #e2eaf2",
    "#Q c #e2edf4",
    "#r c #e3ebf3",
    "## c #ebf1fa",
    ".8 c #f0f5fc",
    "#k c #f1f4f6",
    "#G c #f5f8f9",
    "#. c #f8fbfe",
    "Qt c #ff00ff",
    ".9 c #ffffff",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQt.#.a.b.c.d.e.f.g.h.iQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.j.k.l.m.n.o.p.q.r.s.t.u.v.iQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.w.x.y.m.n.o.p.q.r.s.t.z.A.B.CQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.D.E.y.m.n.o.p.q.r.s.t.z.F.G.HQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.I.J.K.L.M.o.p.q.r.N.O.P.Q.R.HQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.S.T.U.V.W.X.Y.Z.0.1.2.3.4.5.HQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.6.7.8.9.9.9#.###a#b#c#d#e#f.HQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt#g#h#i#j#k.9#.###a#l#m#n#o#p#qQtQtQtQtQtQtQtQt",
    "QtQtQtQtQt.S.T#r#s#t#u#v#w#x#y#z#A#B.5#C#D#EQtQtQtQtQtQt",
    "QtQtQtQtQt.S.T#F.9.9#G#.###a#H#c#d#I.5#C#J#J#K#LQtQtQtQt",
    "QtQtQtQtQt.S.T#M.9.9#u#.###a#N#c#d#I.5#C#J#J#J#J#OQtQtQt",
    "QtQtQtQtQt.S.T#M.9.9#u#.###a#N#c#d#I.5#C#J#J#J#J#JQtQtQt",
    "QtQtQtQtQt.S.T#M.9.9#u#.###a#N#c#d#I.5#C#J#J#J#J#JQtQtQt",
    "QtQtQtQtQt.S.T#M.9.9#u#.###a#N#c#d#I.5#C#J#J#J#PQtQtQtQt",
    "QtQtQtQtQt.S.T#M.9.9#u#.###a#N#c#d#I.5#C#J#P#QQtQtQtQtQt",
    "QtQtQtQtQt#R#S#M.9.9#u#.###a#N#c#d#I#T#U#EQtQtQtQtQtQtQt",
    "QtQtQtQtQt.j#V#W.H.9#u#.###a#N#X#Y#Z#0QtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQt.#.a.X#1.Y.Z#R#2.W#3QtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt",
    "QtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQtQt"
};


/*
 *  Constructs a MemoPopup as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MemoPopup::MemoPopup( QWidget* parent, const char* name )
        : QWidget( parent, name ),
        image1( (const char **) image1_data ) {
    KStandardDirs   *dirs   = KGlobal::dirs();
    QString         sPicsPath;
	dirs->addResourceDir( "data", "/usr/share/apps" );
    sPicsPath = dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" );

    if ( !name )
        setName( "MemoPopup" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 400, 250 ) );
    setIcon( QPixmap(sPicsPath + "nateon.png") );
//   setSizeGripEnabled( TRUE );
    MemoPopupLayout = new QVBoxLayout( this, 11, 6, "MemoPopupLayout");

    layout6 = new QVBoxLayout( 0, 0, 6, "layout6");

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4");
    /*
      textLabel1 = new QLabel( this, "textLabel1" );
      textLabel1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, textLabel1->sizePolicy().hasHeightForWidth() ) );
      layout4->addWidget( textLabel1 );
    */
    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setMinimumSize( QSize( 65, 24 ) );
    textLabel1->setMaximumSize( QSize( 65, 24 ) );
    layout4->addWidget( textLabel1 );
    /*
      labelSender = new QLabel( this, "labelSender" );
      layout4->addWidget( labelSender );
      layout6->addLayout( layout4 );
    */
    labelSender = new QLabel( this, "labelSender" );
    labelSender->setMinimumSize( QSize( 0, 24 ) );
    labelSender->setMaximumSize( QSize( 32767, 24 ) );
    layout4->addWidget( labelSender );
    layout6->addLayout( layout4 );

    layout5 = new QHBoxLayout( 0, 0, 6, "layout5");
    /*
      textLabel3 = new QLabel( this, "textLabel3" );
      textLabel3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, textLabel3->sizePolicy().hasHeightForWidth() ) );
      layout5->addWidget( textLabel3 );
    */
    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setMinimumSize( QSize( 65, 24 ) );
    textLabel3->setMaximumSize( QSize( 65, 24 ) );
    layout5->addWidget( textLabel3 );
    /*
      labelReceiver = new QLabel( this, "labelReceiver" );
      layout5->addWidget( labelReceiver );
      layout6->addLayout( layout5 );
    */
    labelReceiver = new QLabel( this, "labelReceiver" );
    labelReceiver->setMinimumSize( QSize( 0, 24 ) );
    labelReceiver->setMaximumSize( QSize( 32767, 24 ) );
    layout5->addWidget( labelReceiver );
    layout6->addLayout( layout5 );

    labelMemo = new Q3TextEdit( this, "labelMemo" );
    labelMemo->setPaletteForegroundColor( QColor( 83, 83, 83 ) );
    labelMemo->setPaletteBackgroundColor( QColor( 255, 255, 255 ) );
    labelMemo->setAlignment( int( Qt::AlignTop ) );
    labelMemo->setTextFormat( Qt::RichText );
    labelMemo->setWordWrap( Q3TextEdit::WidgetWidth );
    labelMemo->setReadOnly( true );
    layout6->addWidget( labelMemo );

    layout2 = new QHBoxLayout( 0, 0, 6, "layout2");
    Horizontal_Spacing2 = new QSpacerItem( 180, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( Horizontal_Spacing2 );

    buttonReply = new ShapeButton( this, sPicsPath + "bt_img_repl_nor.bmp" );
    buttonReply->setPressedShape( sPicsPath + "bt_img_repl_down.bmp" );
    buttonReply->setMouseOverShape( sPicsPath + "bt_img_repl_ov.bmp" );
    buttonReply->setMinimumSize( QSize( 80, 24 ) );
    buttonReply->setMaximumSize( QSize( 80, 24 ) );

    // buttonReply->setAutoDefault( TRUE );
    layout2->addWidget( buttonReply );

    buttonReplyAll = new ShapeButton( this, sPicsPath + "bt_img_allrepl_nor.bmp" );
    buttonReplyAll->setPressedShape( sPicsPath + "bt_img_allrepl_down.bmp" );
    buttonReplyAll->setMouseOverShape( sPicsPath + "bt_img_allrepl_ov.bmp" );
    buttonReplyAll->setMinimumSize( QSize( 80, 24 ) );
    buttonReplyAll->setMaximumSize( QSize( 80, 24 ) );

    // buttonReplyAll->setAutoDefault( TRUE );
    // buttonReplyAll->setDefault( TRUE );
    layout2->addWidget( buttonReplyAll );

    buttonForward = new ShapeButton( this, sPicsPath + "bt_img_forw_nor.bmp" );
    buttonForward->setPressedShape( sPicsPath + "bt_img_forw_down.bmp" );
    buttonForward->setMouseOverShape( sPicsPath + "bt_img_forw_ov.bmp" );
    buttonForward->setMinimumSize( QSize( 80, 24 ) );
    buttonForward->setMaximumSize( QSize( 80, 24 ) );

    // buttonForward->setAutoDefault( TRUE );
    layout2->addWidget( buttonForward );

    buttonClose = new ShapeButton( this, sPicsPath + "bt_img_close_nor.bmp" );
    buttonClose->setPressedShape( sPicsPath + "bt_img_close_down.bmp" );
    buttonClose->setMouseOverShape( sPicsPath + "bt_img_close_ov.bmp" );
    buttonClose->setMinimumSize( QSize( 60, 24 ) );
    buttonClose->setMaximumSize( QSize( 60, 24 ) );

    // buttonDelete->setIconSet( QIconSet( image1 ) );
    layout2->addWidget( buttonClose );
    layout6->addLayout( layout2 );
    MemoPopupLayout->addLayout( layout6 );
    languageChange();
    resize( QSize(400, 250).expandedTo(minimumSizeHint()) );
    //clearWState( WState_Polished );
}

/*
 *  Destroys the object and frees any allocated resources
 */
MemoPopup::~MemoPopup() {
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void MemoPopup::languageChange() {
    setCaption( trUtf8( "\xeb\xb0\x9b\xec\x9d\x80\xec\xaa\xbd\xec\xa7\x80" ) );
    textLabel1->setText( trUtf8( "\x3c\x62\x3e\xeb\xb3\xb4\xeb\x82\xb8\xec\x82\xac\xeb\x9e\x8c\x3c\x2f\x62\x3e\x20\x3a"
                                 "" ) );
    labelSender->setText( tr( "textLabel2" ) );
    textLabel3->setText( trUtf8( "\x3c\x62\x3e\xeb\xb0\x9b\xeb\x8a\x94\xec\x82\xac\xeb\x9e\x8c\x3c\x2f\x62\x3e\x20\x3a"
                                 "" ) );
    labelReceiver->setText( tr( "textLabel4" ) );
    labelMemo->setText( tr( "textLabel5" ) );
    // buttonReply->setText( tr( "Repl&y" ) );
    // buttonReply->setAccel( QKeySequence( tr( "Alt+Y" ) ) );
    // buttonReplyAll->setText( tr( "ReplyAll" ) );
    // buttonReplyAll->setAccel( QKeySequence( QString::null ) );
    // buttonForward->setText( tr( "Forward" ) );
    // buttonForward->setAccel( QKeySequence( QString::null ) );
}

#include "memopopupinterface.moc"
