/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "memoviewinterface.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qtoolbutton.h>
#include <q3textedit.h>
// #include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <Q3HBoxLayout>
#include <Q3VBoxLayout>
#include <QLabel>
#include <QMouseEvent>

static const char* const image1_data[] = {
    "18 18 13 1",
    "c c #000000",
    "d c #5a5664",
    "i c #655b60",
    "g c #790000",
    "k c #898792",
    "# c #a58363",
    "j c #c4c3c9",
    "f c #cc6600",
    "e c #e99900",
    "h c #ffb287",
    "b c #ffbf55",
    "a c #ffdfaa",
    ". c #ffffff",
    "......######......",
    "....##aaaaab##....",
    "...#ccaaaaaccb#...",
    "..#caacaaacaacb#..",
    ".#aaaaaaaaaaaabb#.",
    ".#aaaaaaaaaaaaab#.",
    "#aaaadcaaadcaaabb#",
    "#aaaadcaaadcaaabb#",
    "#aaaadcaaadcaaabb#",
    "#aeeeaaaaaaaeeebb#",
    "#aeeeaaaaaaaeeeab#",
    "#baaafgggggfaaabb#",
    ".#baaghhhhhgaabb#.",
    ".#bbaaghhhgaabbb#.",
    "..#bbaagggabbbb#..",
    "...#bbbbbbbbbb#ijj",
    "....##bbbbbb##iikj",
    "......######iikjjj"
};


/*
 *  Constructs a MemoQW as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
MemoQW::MemoQW( QWidget* parent, const char* name, Qt::WFlags fl )
        : QWidget( parent, name, fl ),
        image1( (const char **) image1_data ) {

    KStandardDirs   *dirs   = KGlobal::dirs();
	dirs->addResourceDir( "data", "/usr/share/apps" );
    QString         sPicsPath;
    sPicsPath = dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" );

    if ( !name )
        setName( "MemoQW" );
    setIcon( QPixmap(sPicsPath + "nateon.png") );
    MemoQWLayout = new Q3VBoxLayout( this, 11, 6, "MemoQWLayout");

    layout19 = new Q3VBoxLayout( 0, 0, 6, "layout19");

    layout16 = new Q3HBoxLayout( 0, 0, 6, "layout16");

    pushButton3 = new ShapeButton( this, sPicsPath + "bt_img_receiver_nor.bmp" );
    pushButton3->setPressedShape( sPicsPath + "bt_img_receiver_down.bmp" );
    pushButton3->setMouseOverShape( sPicsPath + "bt_img_receiver_ov.bmp" );
    pushButton3->setMinimumSize( QSize( 80, 24 ) );
    pushButton3->setMaximumSize( QSize( 80, 24 ) );

    layout16->addWidget( pushButton3 );

    lineEdit1 = new QLineEdit( this, "lineEdit1" );
    layout16->addWidget( lineEdit1 );

    emoticonTB = new ShapeButton( this, sPicsPath + "chw_emoticon.bmp" );
    emoticonTB->setPressedShape( sPicsPath + "chw_emoticon_down.bmp" );
    emoticonTB->setMouseOverShape( sPicsPath + "chw_emoticon_ov.bmp" );
    emoticonTB->setMinimumSize( QSize( 30, 20 ) );
    emoticonTB->setMaximumSize( QSize( 30, 20 ) );
    // emoticonTB->setIconSet( QIconSet( image1 ) );
    layout16->addWidget( emoticonTB );

    fontButton = new ShapeButton( this, sPicsPath + "chw_font.bmp" );
    fontButton->setPressedShape( sPicsPath + "chw_font_down.bmp" );
    fontButton->setMouseOverShape( sPicsPath + "chw_font_ov.bmp" );
    fontButton->setMinimumSize( QSize( 30, 20 ) );
    fontButton->setMaximumSize( QSize( 30, 20 ) );

    layout16->addWidget( fontButton );

    layout19->addLayout( layout16 );

    textEdit2 = new Q3TextEdit( this, "textEdit2" );
    // textEdit2->setWordWrap( QTextEdit::WidgetWidth );
    layout19->addWidget( textEdit2 );

    layout18 = new Q3HBoxLayout( 0, 0, 6, "layout18");

    textLabel2 = new QLabel( this, "textLabel2" );
    layout18->addWidget( textLabel2 );

    /*
      checkBox1 = new QCheckBox( this, "checkBox1" );
      layout18->addWidget( checkBox1 );
    */

    textLabel1 = new MyLabel( this, "textLabel1" );
    textLabel1->setMinimumSize( QSize( 90, 24 ) );
    textLabel1->setMaximumSize( QSize( 90, 24 ) );
    textLabel1->setPaletteForegroundColor( QColor( 51, 102, 153 ) );
    layout18->addWidget( textLabel1 );
    spacer8 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout18->addItem( spacer8 );

    sendPB = new ShapeButton( this, sPicsPath + "bt_img_send_nor.bmp" );
    sendPB->setPressedShape( sPicsPath + "bt_img_send_down.bmp" );
    sendPB->setMouseOverShape( sPicsPath + "bt_img_send_ov.bmp" );
    sendPB->setMinimumSize( QSize( 80, 24 ) );
    sendPB->setMaximumSize( QSize( 80, 24 ) );

    layout18->addWidget( sendPB );

    clearPB = new ShapeButton( this, sPicsPath + "bt_img_rewri_nor.bmp" );
    clearPB->setPressedShape( sPicsPath + "bt_img_rewri_down.bmp" );
    clearPB->setMouseOverShape( sPicsPath + "bt_img_rewri_ov.bmp" );
    clearPB->setMinimumSize( QSize( 81, 24 ) );
    clearPB->setMaximumSize( QSize( 81, 24 ) );

    // clearPB->setEnabled( FALSE );
    layout18->addWidget( clearPB );
    layout19->addLayout( layout18 );
    MemoQWLayout->addLayout( layout19 );
    languageChange();
    resize( QSize(443, 315).expandedTo(minimumSizeHint()) );
    //clearWState( WState_Polished );

    // signals and slots connections
    connect( clearPB, SIGNAL( clicked() ), SLOT( slotClear() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
MemoQW::~MemoQW() {
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void MemoQW::languageChange() {
    //  setCaption( trUtf8( "\xec\xaa\xbd\xec\xa7\x80\xeb\xb3\xb4\xeb\x82\xb4\xea\xb8\xb0" ) );
    setCaption( trUtf8( "쪽지 쓰기" ) );
    // pushButton3->setText( tr( "&Receiver" ) );
    // pushButton3->setAccel( QKeySequence( tr( "Alt+R" ) ) );
    // lineEdit1->setText( tr( "Doo-Hyun Jang <ring0320@lycos.co.kr>;Doo-Hyun Jang <ring0320@nate.com>" ) );
    // emoticonTB->setText( QString::null );
    // fontButton->setText( tr( "PB" ) );
    // fontButton->setAccel( QKeySequence( QString::null ) );
    textLabel2->setText( tr( "0000/2000" ) );
    // checkBox1->setText( trUtf8( "\xec\x88\x98\xec\x8b\xa0\xed\x99\x95\xec\x9d\xb8" ) );
    textLabel1->setText( trUtf8( "\x3c\x75\x3e\xec\x9b\x90\xeb\xac\xb8\xed\x91\x9c\xec\x8b\x9c\x20\xec\x84\xa4\xec\xa0"
                                 "\x95\x3c\x2f\x75\x3e" ) );
    // sendPB->setText( tr( "Se&nd" ) );
    // sendPB->setAccel( QKeySequence( tr( "Alt+N" ) ) );
    // clearPB->setText( tr( "Cle&ar" ) );
    //clearPB->setAccel( QKeySequence( tr( "Alt+A" ) ) );
}

void MyLabel::mousePressEvent(QMouseEvent * e) {
    emit clicked();
    QLabel::mousePressEvent( e );
}

MyLabel::MyLabel(QWidget * parent, const char * name):
        QLabel( parent, name ) {
}

void MemoQW::slotClear() {
    int nResult = KMessageBox::messageBox(this, KMessageBox::QuestionYesNo, QString::fromUtf8("쪽지 내용을 모두 지우시겠습니까?"), QString::fromUtf8("다시쓰기 확인") );

    if ( nResult == KMessageBox::Yes ) {
        textEdit2->clear();
    }
}

#include "memoviewinterface.moc"
