/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knateoncommon.h"
#include "filetransferinterface.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qprogressbar.h>
#include <q3groupbox.h>
#include <qframe.h>
#include <q3header.h>
#include <q3listview.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <QGridLayout>
#include <QHBoxLayout>
#include <QVBoxLayout>

/*
 *  Constructs a FileTransferForm as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
FileTransferForm::FileTransferForm( QWidget* parent, const char* name, bool modal, Qt::WFlags fl )
        : QDialog( parent, name, modal, fl ) {
    KStandardDirs   *dirs   = KGlobal::dirs();
	dirs->addResourceDir( "data", "/usr/share/apps" );
    sPicsPath = dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" ) ;
    if ( !name )
        setName( "FileTransferForm" );
    setIcon( QPixmap(sPicsPath + "nateon.png") );
    FileTransferFormLayout = new QGridLayout( this, 1, 1, 11, 6, "FileTransferFormLayout");

    layout1 = new QHBoxLayout( 0, 0, 6, "layout1");

    fileNameLabel = new QLabel( this, "fileNameLabel" );
    layout1->addWidget( fileNameLabel );
    spacer1 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout1->addItem( spacer1 );

    FileTransferFormLayout->addLayout( layout1, 0, 0 );

    layout6 = new QHBoxLayout( 0, 0, 6, "layout6");

    progressBar1 = new QProgressBar( this );
    progressBar1->setMinimumSize( QSize( 400, 0 ) );
    //  progressBar1->setMaximumSize( QSize( 400, 32767 ) );
    progressBar1->setValue( 0 );
	progressBar1->setTextVisible( true );
    layout6->addWidget( progressBar1 );

    cancelButton = new QPushButton( this, "cancelButton" );
    cancelButton->setFlat( TRUE );
    layout6->addWidget( cancelButton );

    FileTransferFormLayout->addLayout( layout6, 1, 0 );

    layout3 = new QHBoxLayout( 0, 0, 6, "layout3");

    kbStatusLabel = new QLabel( this, "kbStatusLabel" );
    layout3->addWidget( kbStatusLabel );
    spacer2 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout3->addItem( spacer2 );

    FileTransferFormLayout->addLayout( layout3, 2, 0 );

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4");
    spacer3 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer3 );

    closeButton = new QPushButton( this, "closeButton" );
    layout4->addWidget( closeButton );
    spacer4 = new QSpacerItem( 40, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer4 );

    FileTransferFormLayout->addLayout( layout4, 3, 0 );
    spacer5 = new QSpacerItem( 20, 1, QSizePolicy::Minimum, QSizePolicy::Minimum );
    FileTransferFormLayout->addItem( spacer5, 4, 0 );

    fileListGroupBox = new Q3GroupBox( this, "fileListGroupBox" );
    fileListGroupBox->setFrameShape( Q3GroupBox::NoFrame );
    fileListGroupBox->setFrameShadow( Q3GroupBox::Plain );
    fileListGroupBox->setColumnLayout(0, Qt::Vertical );
    fileListGroupBox->layout()->setSpacing( 10 );
    fileListGroupBox->layout()->setMargin( 0 );
    fileListGroupBoxLayout = new QVBoxLayout( fileListGroupBox->layout() );
    fileListGroupBoxLayout->setAlignment( Qt::AlignTop );

    line1 = new QFrame( fileListGroupBox, "line1" );
    line1->setFrameShape( QFrame::HLine );
    line1->setFrameShadow( QFrame::Sunken );
    line1->setFrameShape( QFrame::HLine );
    fileListGroupBoxLayout->addWidget( line1 );

    fileListView = new Q3ListView( fileListGroupBox, "fileListView" );
    fileListView->addColumn( tr( "" ), 0 );
    fileListView->addColumn( UTF8( "이름" ) );
    fileListView->addColumn( UTF8( "파일명" ) );
    fileListView->addColumn( UTF8( "파일크기" ) );
    fileListView->addColumn( UTF8( "방향" ) );
    fileListView->addColumn( tr( "%" ) );
    fileListView->addColumn( UTF8( "상태" ) );
    fileListView->addColumn( UTF8( "전송량" ) );
    fileListView->hideColumn(1);
    fileListView->setSelectionMode( Q3ListView::Single );
    // fileListView->hideColumn(6);
    // fileListView->hideColumn(7);

    // fileListView->setAllColumnsShowFocus( TRUE );
    fileListGroupBoxLayout->addWidget( fileListView );


    FileTransferFormLayout->addWidget( fileListGroupBox, 5, 0 );
    languageChange();
    // resize( QSize(500, 366).expandedTo(minimumSizeHint()) );
    //clearWState( WState_Polished );

    // signals and slots connections
    connect( closeButton, SIGNAL( clicked() ), this, SLOT( close() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
FileTransferForm::~FileTransferForm() {
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void FileTransferForm::languageChange() {
    setCaption( UTF8( "파일전송" ) );
    fileNameLabel->setText( UTF8( "없음" ) );
    cancelButton->setText( UTF8( "중지" ) );
    kbStatusLabel->setText( tr( "0 / 0 Bytes" ) );
    closeButton->setText( UTF8( "닫기" ) );
    fileListGroupBox->setTitle( QString::null );
#if 0
    fileListView->header()->setLabel( 0, tr( "Cookie" ) );
    fileListView->header()->setLabel( 1, UTF8( "ID" ) );
    fileListView->header()->setLabel( 2, UTF8( "파일명" ) );
    fileListView->header()->setLabel( 3, UTF8( "파일크기" ) );
    fileListView->header()->setLabel( 4, UTF8( "방향" ) );
    fileListView->header()->setLabel( 5, UTF8( "%" ) );
    fileListView->header()->setLabel( 6, tr( "Status" ) );
#endif
    fileListView->clear();
#if 0
    Q3ListViewItem * item = new Q3ListViewItem( fileListView, 0 );
    item->setText( 0, tr( "453:456:123" ) );
    item->setText( 1, tr( "ring0320@lycos.co.kr" ) );
    item->setText( 2, tr( "x2.png" ) );
    item->setText( 3, tr( "45621" ) );
    item->setText( 4, tr( "542bps" ) );
    item->setText( 5, tr( "15%" ) );

    item = new Q3ListViewItem( fileListView, item );
    item->setText( 0, tr( "123:456:789" ) );
    item->setText( 1, tr( "ring0320@nate.com" ) );
    item->setText( 2, tr( "x1.png" ) );
    item->setText( 3, tr( "32145" ) );
    item->setText( 4, tr( "410bps" ) );
    item->setText( 5, tr( "21%" ) );
#endif
}

#include "filetransferinterface.moc"
