/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kaboutdata.h>
#include <stdlib.h>
#include "utils.h"
#include "../nateon/util/common.h"
#include "version.h"

extern nmconfig stConfig;

LNMUtils::LNMUtils(QObject *parent, const char *name)
        : QObject(parent, name) {
}


LNMUtils::~LNMUtils() {
}

#include "utils.moc"

// extern char version[];

static char version[1000];

KAboutData *
LNMUtils::getAboutData( const char *about ) {
    using namespace AutoVersion;

    memset(version, 0x00, 1000);
    snprintf( version, 1000, "%ld.%ld.%ld.%ld %s", MAJOR, MINOR, BUILD, REVISION, STATUS );

    KAboutData *aboutData;
    aboutData = new KAboutData(	"nateon",
								0,
								ki18n(I18N_NOOP("네이트온 메신저")),
								I18N_NOOP(version),
								ki18n(I18N_NOOP(about)),
								KAboutData::License_Custom,
								ki18n("(C) 2007 SK Communications, Inc."),
								KLocalizedString(),
								"http://nateonweb.nate.com");
    /*!
      개발자 정보
    */
	aboutData->addAuthor(	ki18n(I18N_NOOP("이종우 (oopslee)")), 
							ki18n("프로젝트 관리자"), 
							"oopslee@gmail.com", 
							"http://kldp.net/projects/nateon/" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("장두현")), 
							ki18n("프로젝트 관리자"), 
							"dh.jang@gmail.com", 
							"http://kldp.net/projects/nateon/" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("kakapapa")), 
							ki18n("개발자"), 
							"kakapapa@nate.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("YoungHo Park")), 
							ki18n("개발자"), 
							"amesianx@nate.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("박준규 (segfault87)")),
							ki18n("프로젝트 관리자"), 
							"mastermind@planetmono.org", 
							"http://planetmono.org" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("Byoung Ywan Cho (korone)")),
							ki18n("개발자"), 
							"korone@gmail.com", 
							"http://korone.net" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("김태훈 (kth321)")), 
							ki18n("개발자"), 
							"kth3321@gmail.com", 
							"http://onestep.tistory.com/" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("라병영 (la9527)")), 
							ki18n("개발자"), 
							"la9527@yahoo.co.kr" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("강준석 (zingle)")), 
							ki18n("개발자"), 
							"zingle@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("임인택 (litnsio2)")), 
							ki18n("개발자"), 
							"masterhand@gmail.com", 
							"http://janbyul.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("김동진 (tobetter)")), 
							ki18n("개발자"), 
							"tobetter@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("신홍중 (whitepoo)")), 
							ki18n("개발자"), 
							"sjtetris@daum.net" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("정재훈 (dicastyle)")), 
							ki18n("개발자"), 
							"dicastyle@nate.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("조병탁 (jbtstyle)")), 
							ki18n("개발자"), 
							"jbtstyle@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("전창현 (expectedtime)")), 
							ki18n(I18N_NOOP("개발자")), 
							"cch870906@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("노연진 (nyjin)")), 
							ki18n(I18N_NOOP("개발자")), 
							"zacronan@naver.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("유경진 (kyoji)")), 
							ki18n(I18N_NOOP("개발자")), 
							"yookyoji@hotmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("최수현 (soohyunc)")), 
							ki18n("개발자"), 
							"s.choi@hackers.org.uk", 
							"http://www.cs.ucl.ac.uk/staff/S.Choi" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("이지석 (morgana)")), 
							ki18n("개발자"), 
							"morgana@naver.com", 
							"http://morgana.tistory.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("박영호 (amesianx)")), 
							ki18n("개발자"), 
							"amesianx@nate.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("박청규 (cheongpark)")), 
							ki18n("개발자"), 
							"ck0park@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("윤석태 (luciferX2)")), 
							ki18n("개발자"), 
							"luciferX2@gmail.com" );
    aboutData->addAuthor(	ki18n(I18N_NOOP("신근태 (killme)")), 
							ki18n("개발자"), 
							"keuntae.shin@gmail.com" );

    /*!
      도움주신 분
    */
    aboutData->addCredit(	ki18n(I18N_NOOP("한혜진")), 
							ki18n("기획"), 
							"imyayayaya@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("이은아")), 
							ki18n("기획"), 
							"ena27@nate.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("이승명")), 
							ki18n("디자이너"), 
							"smdesign@nate.com", 
							"http://www.leesm.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("박상완")), 
							ki18n("버그트래킹서버 제공, 버그 수정"), 
							"nakyup@gmail.com", 
							"http://people.sarang.net" );
    aboutData->addCredit(	ki18n(I18N_NOOP("강정희")), 
							ki18n("automake 부분"), 
							"keizie@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("김가현")), 
							ki18n("설치 도움"), 
							"kfmes@kfmes.com", 
							"http://kfmes.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("A Lee")), 
							ki18n("Debian 패키징"), 
							"alee@debian.org" );
    aboutData->addCredit(	ki18n(I18N_NOOP("Hyunsik Choi")), 
							ki18n("Gentoo 패키징"), 
							"c0d3h4ck@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("Barosl LEE")), 
							ki18n("(k)ubuntu 패키징"), 
							"", 
							"http://barosl.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("황윤성 (hys545)")), 
							ki18n("Asianux 패키징"), 
							"hys545@dreamwiz.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("시노 삐 (sinovino)")), 
							ki18n("(k)ubuntu 패키징"), 
							"sinovino@sinovino.org" );
    aboutData->addCredit(	ki18n(I18N_NOOP("노상균 (freesky)")), 
							ki18n("아치리눅스(Arch Linux) 패키징"), 
							"freesky80@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("정하영 (sixt06)")), 
							ki18n("openSUSE 패키징"), 
							"sixt06@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("이상현 (sanghyun)")), 
							ki18n("Fedoa 패키징"), 
							"SangHyun.0925@gmail.com" );
    aboutData->addCredit(	ki18n(I18N_NOOP("나동희 (acsungcode)")), 
							ki18n("Ubuntu 패키징"), 
							"corona10@gmail.com", 
							"http://acsungcode.tistory.com/" );
    aboutData->addCredit(	ki18n(I18N_NOOP("Hyun Seung Bum (orion203)")), 
							ki18n("CentOS 패키징"), 
							"orion_203@naver.com" );

    return aboutData;
}

// #define NETDEBUG 1

void LNMUtils::openURL( const QString &sURL ) {
    QString sCommand;
    if ( stConfig.usedefaultwebbrowser ) {
        sCommand = stConfig.defaultwebbrowser;
        sCommand += " ";
        sCommand += "'";
        sCommand += sURL;
        sCommand += "'";
#ifdef NETDEBUG
        kDebug() << stConfig.defaultwebbrowser << " : "<< sCommand;
#endif
        /*!
         * Bugs 304875 - modified by luciferX2@gmail.com, 20081103
         */
        //system( sCommand.data() );
        KRun::runCommand(sCommand, NULL);
    } else {
#ifdef NETDEBUG
        kDebug() << "KRun (" << sURL << ")";
#endif
        KRun::runUrl( sURL, "text/html", NULL);
    }
    return;
}


void LNMUtils::sendMail(const QString & sEMails) {
    QString sCommand;
    if ( QFile::exists( "/bin/xdg-email" ) ) {
        sCommand = "/bin/xdg-email";
    } else if ( QFile::exists( "/usr/bin/xdg-email" ) ) {
        sCommand = "/usr/bin/xdg-email";
    } else if ( QFile::exists( "/usr/local/bin/xdg-email" ) ) {
        sCommand = "/usr/local/bin/xdg-email";
    } else {
#ifdef NETDEBUG
        kDebug() << "KRun (" << sEMails << ")";
#endif
        QString sMails("mailto:");
        sMails += sEMails;
        new KRun( sMails, NULL );
        return;
    }
    sCommand += " ";
    sCommand += "'";
    sCommand += sEMails;
    sCommand += "'";
#ifdef NETDEBUG
    kDebug() << sCommand;
#endif
    int ret = system( sCommand.toAscii() );
	Q_UNUSED( ret );
    return;
}

void LNMUtils::openBridgeURL(const QString & BrCode, const QString &BrTicket, const QString & BrParam) {
    QString sURL("http://br.nate.com/index.php");
    if ( !BrCode.isNull() && !BrCode.isEmpty() ) {
        sURL += "?code=";
        sURL += BrCode;
    } else {
        /*!
         * Bridge Code 가 없음. ???
         */
        return;
    }

    if ( !BrTicket.isNull() && !BrTicket.isEmpty() ) {
        sURL += "&t=";
        sURL += BrTicket;
    }

    if ( !BrParam.isNull() && !BrParam.isEmpty() ) {
        sURL += "&param=";
        sURL += BrParam;
    }

    QString sCommand;
    if ( stConfig.usedefaultwebbrowser ) {
        sCommand = stConfig.defaultwebbrowser;
        sCommand += " ";
        sCommand += "'";
        sCommand += sURL;
        sCommand += "'";
#ifdef NETDEBUG
        kDebug() << stConfig.defaultwebbrowser << " : "<< sCommand;
#endif
        int ret = system( sCommand.toAscii() );
		Q_UNUSED( ret );
    } else {
        /*!
         * 브라우져 설정이 되있지 않음.
         */
#ifdef NETDEBUG
        kDebug() << "KRun (" << sURL << ")";
#endif
        KRun::runUrl( sURL, "text/html", NULL);
        return;
    }
}

void LNMUtils::openBridgeURL(const QString & BrCode, const QString &BrTicket, const QString & BrParam, bool BrToolBarYN, unsigned int BrWidth, unsigned int BrHeight) {
    Q_UNUSED( BrToolBarYN );
    Q_UNUSED( BrWidth );
    Q_UNUSED( BrHeight );

    QString sURL("http://br.nate.com/index.php");
    if ( !BrCode.isNull() && !BrCode.isEmpty() ) {
        sURL += "?code=";
        sURL += BrCode;
    } else {
        /*!
         * Bridge Code 가 없음. ???
         */
        return;
    }

    if ( !BrTicket.isNull() && !BrTicket.isEmpty() ) {
        sURL += "&t=";
        sURL += BrTicket;
    }

    if ( !BrParam.isNull() && !BrParam.isEmpty() ) {
        sURL += "&param=";
        sURL += BrParam;
    }

    QString sCommand;
    if ( stConfig.usedefaultwebbrowser ) {
        sCommand = stConfig.defaultwebbrowser;
        sCommand += " ";
        sCommand += "'";
        sCommand += sURL;
        sCommand += "'";
#ifdef NETDEBUG
        kDebug() << stConfig.defaultwebbrowser << " : "<< sCommand;
#endif
        int ret = system( sCommand.toAscii() );
		Q_UNUSED( ret );
    } else {
        /*!
         * 브라우져 설정이 되있지 않음.
         */
#ifdef NETDEBUG
        kDebug() << "KRun (" << sURL << ")";
#endif
        KRun::runUrl( sURL, "text/html", NULL );
        return;
    }
}


