import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

public class Editor extends Nemo implements ActionListener {
	private String fileName;

	public static void main(String[] args) {
		if (args.length != 3) {
			System.out.println(": Editor ϸ ټ ĭ");
			System.exit(1);
		}
		new Editor(args[0], Integer.parseInt(args[1]),
			Integer.parseInt(args[2]));
	}

	public Editor(String fileName, int rows, int cols) {
		super(rows, cols);

		this.fileName = fileName;
		Picture picture = new Picture(this);
		JButton button = new JButton("");
		button.addActionListener(this);
		JFrame frame = new JFrame("");
		frame.getContentPane().add(picture, BorderLayout.CENTER);
		frame.getContentPane().add(button, BorderLayout.NORTH);
		frame.pack();
		frame.setVisible(true);
	}

	public void actionPerformed(ActionEvent ev) {
		PrintWriter out = null;
		try {
			out = new PrintWriter(new FileWriter(fileName));
		}
		catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}

		out.println(getNRows() + " " + getNCols());
		for (int i = 0; i < getNRows(); i++) {
			out.println(rowMarks[i].toNumbers().toString());
		}
		for (int i = 0; i < getNCols(); i++) {
			out.println(colMarks[i].toNumbers().toString());
		}
		out.close();

		System.exit(1);
	}

	public boolean finished() {
		return false;
	}
}
