public class Marks {
	private int size;
	private boolean[] marked;

	public Marks(int size) {
		this.size = size;
		marked = new boolean[size];
	}

	public int size() {
		return size;
	}

	public boolean marked(int i) {
		return marked[i];
	}

	public void mark(int i) {
		marked[i] = true;
	}

	public void unmark(int i) {
		marked[i] = false;
	}

	public Numbers toNumbers() {
		Numbers numbers = new Numbers();
		int n = 0;
		for (int i = 0; i < size; i++) {
			if (marked[i]) {
				n++;
			} else {
				if (n != 0) {
					numbers.add(n);
					n = 0;
				}
			}
		}
		if (n != 0)
			numbers.add(n);
		return numbers;
	}
}
