import java.io.*;
import java.util.*;

public class Nemo {
	private int nRows;
	private int nCols;
	private Numbers[] rows;
	private Numbers[] cols;
	protected Marks[] rowMarks;
	protected Marks[] colMarks;

	public Nemo(int nRows, int nCols) {
		init(nRows, nCols);
	}

	private void init(int nRows, int nCols) {
		this.nRows = nRows;
		this.nCols = nCols;
		rows = new Numbers[nRows];
		cols = new Numbers[nCols];
		rowMarks = new Marks[nRows];
		for (int i = 0; i < nRows; i++)
			rowMarks[i] = new Marks(nCols);
		colMarks = new Marks[nCols];
		for (int i = 0; i < nCols; i++)
			colMarks[i] = new Marks(nRows);
	}

	public int getNRows() {
		return nRows;
	}

	public int getNCols() {
		return nCols;
	}

	public boolean marked(int row, int col) {
		return rowMarks[row].marked(col);
	}

	public void mark(int row, int col) {
		rowMarks[row].mark(col);
		colMarks[col].mark(row);
	}

	public void setRow(int row, Numbers numbers) {
		rows[row] = numbers;
	}

	public void setCol(int col, Numbers numbers) {
		cols[col] = numbers;
	}

	public boolean finished() {
		for (int i = 0; i < nRows; i++) {
			if (!rowMarks[i].toNumbers().equals(rows[i]))
				return false;
		}
		for (int i = 0; i < nCols; i++) {
			if (!colMarks[i].toNumbers().equals(cols[i]))
				return false;
		}
		return true;
	}

	public Numbers getRow(int i) {
		return rows[i];
	}

	public Numbers getCol(int i) {
		return cols[i];
	}

	public Nemo(Reader in) throws IOException {
		load(in);
	}

	private Numbers parseLine(BufferedReader in) throws IOException {
		String s = in.readLine();
		Numbers numbers = new Numbers();
		StringTokenizer st = new StringTokenizer(s);
		while (st.hasMoreTokens()) {
			numbers.add(Integer.parseInt(st.nextToken()));
		}
		return numbers;
	}

	public void unmark(int row, int col) {
		rowMarks[row].unmark(col);
		colMarks[col].unmark(row);
	}

	public void load(Reader in) throws IOException {
		BufferedReader br = new BufferedReader(in);
		Numbers numbers = parseLine(br);
		init(numbers.get(0), numbers.get(1));
		for (int i = 0; i < nRows; i++) {
			setRow(i, parseLine(br));
		}
		for (int i = 0; i < nCols; i++) {
			setCol(i, parseLine(br));
		}
	}
}
