import junit.framework.TestCase;

public class NumbersTest extends TestCase {
	private Numbers numbers;

	public NumbersTest(String name) {
		super(name);
	}

	protected void setUp() {
		numbers = new Numbers();
	}

	public void testSize() {
		assertEquals(0, numbers.size());
	}

	public void testAdd() {
		numbers.add(1);
		assertEquals(1, numbers.size());
	}

	public void testGet() {
		numbers.add(2);
		numbers.add(7);
		assertEquals(7, numbers.get(1));
		assertEquals(2, numbers.get(0));
	}

	public void testEquals() {
		numbers.add(1);
		Numbers n2 = new Numbers();
		n2.add(1);
		assertTrue(numbers.equals(n2));
	}

	public void testToString() {
		assertTrue(numbers.toString().equals(""));
		numbers.add(3);
		assertTrue(numbers.toString().equals("3"));
		numbers.add(7);
		assertTrue(numbers.toString().equals("3 7"));
	}
}
