import javax.swing.*;
import java.awt.*;

public class RowLabels extends JPanel {
	private Dimension d;
	private Nemo nemo;
	private int height;
	private int offset;

	public RowLabels(Nemo nemo) {
		this.nemo = nemo;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		// g.drawRect(0, 0, d.width-1, d.height-1);
		for (int i = 0; i < nemo.getNRows(); i++) {
			g.drawString(nemo.getRow(i).toString(),
				0,  offset + i*height);
		}
	}

	public Dimension getPreferredSize() {
		FontMetrics fm = getGraphics().getFontMetrics();
		height = fm.getHeight();
		offset = fm.getLeading()/2 + fm.getAscent();
		int max = 0;
		for (int i = 0; i < nemo.getNRows(); i++) {
			Numbers numbers = nemo.getRow(i);
			int width = fm.stringWidth(numbers.toString());
			if (width > max)
				max = width;
		}
		d = new Dimension(max, nemo.getNRows() * height);
		return d;
	}
}
